//	Critical Mass be
//	13/7/1997
//	Hamish Carr
//
//	CMassView.h

#pragma once

#include "CMassBlitView.h"
#include "GLView.h"
#include "Ball.h"
#include <gl.h>
#include <glu.h>
#include <glut.h>

const int dragBall = 0, dragObject = 1, dragScale = 2;								//	constants for which form of drag is being performed			

class CMassView : public BGLView													//	our viewing panel
	{
	private:	
	CMBoard theBoard;																//	the board currently being displayed
	BBitmap **theBitmaps;															//	cache for the bitmaps
	BBitmap *theBlitMap;															//	bitmap from which to blit
	CMassBlitView *theBlitView;														//	view to use to set up blitting
	bool acceptClicks;																//	whether to accept clicks from the player
	bool inGLMode;																	//	whether we are in OpenGL mode

	int torusDisplayListID;															//	integer for the display list rep. the torus
	int torusPickListID;															//	integer for the display list for picking
	float xRot, yRot, zRot;															//	direction vector for rotation							
	float scale;
	BallData ball;																	//	the arcball											
	float offset_x, offset_y;														//	allows us to move the object around laterally				
	int dragMode;																	//	start off in dragBall mode								
 	float dragOld_x, dragOld_y;														//	previous x, y coordinates of drag							
	unsigned long texName;															//	name of texture

	void CreateTorus(float ringRadius, float tubeRadius, GLenum mode = GL_RENDER);	//	creates display list for torus
	public:
	CMassView(BRect frame, char *name, BBitmap **newBitmaps);						//	constructor
	virtual void AttachedToWindow();												//	called when added to window
	virtual	void Draw(BRect updateRect);											//	draws the board
	virtual void MouseDown(BPoint where);											//	reacts to mouse clicks
	virtual void MessageReceived(BMessage *theMessage);								//	reacts to messages
	}; // end of class CMassView
